unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, ExtCtrls, Buttons;

const ROWS        = 500000;
const COLS        = 12;

const colLp       =  0;
const colNazwisko =  1;
const colImie     =  2;
const colUlica    =  3;
const colKodp     =  4;
const colMiasto   =  5;
const colDataur   =  6;
const colPesel    =  7;
const colTel      =  8;
const colEmail    =  9;
const colWoj      = 10;
const colZarobek  = 11;

Type

MRec = record
     Lp          : String;
     Nazwisko    : String;
     Imie        : String;
     Ulica       : String;
     Kodp        : String;
     Miasto      : String;
     Dataur      : String;
     Pesel       : String;
     Tel         : String;
     Email       : String;
     Woj         : String;
     Zarobek     : String;
  end;

  TMainForm = class(TForm)
    sg: TStringGrid;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    lblINFO: TLabel;
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);

  private

  public
	 procedure  Koniec();
    procedure  Make_empty_sg();
    procedure  Set_fixed();
    procedure  Wypelnij_1();
	 procedure  Wypelnij_2();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.BitBtn2Click(Sender: TObject);
begin
   Wypelnij_1();
end;

procedure TMainForm.BitBtn3Click(Sender: TObject);
begin
	Wypelnij_2();
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
	lblINFO.Visible := true;
	Application.ProcessMessages();

	Make_empty_sg();

	lblINFO.Visible := false;
	sg.Align := alClient;
end;

procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.Make_empty_sg();
var
	ARow : Integer;
	lp   : Integer;

begin
	sg.DefaultRowHeight := 19;

   sg.ColCount := COLS;
   ARow := 0;

	// SZEROKO KOLUMN
   sg.ColWidths[ 0] :=  40;     // Lp
   sg.ColWidths[ 1] :=  90;     // Nazwisko
   sg.ColWidths[ 2] :=  60;     // Imie
   sg.ColWidths[ 3] := 150;     // Ulica i nr
   sg.ColWidths[ 4] :=  60;     // Kod p
   sg.ColWidths[ 5] :=  90;     // Miejscowosc
   sg.ColWidths[ 6] :=  60;     // Data ur
   sg.ColWidths[ 7] :=  80;     // Pesel
   sg.ColWidths[ 8] :=  60;     // Telefon
   sg.ColWidths[ 9] := 100;     // E-mail
   sg.ColWidths[10] := 100;     // Wojewdztwo
   sg.ColWidths[11] :=  70;     // Zarobek

   // NAGWKI KOLUMN
   sg.Cells[ 0, ARow] := 'Lp';
   sg.Cells[ 1, ARow] := 'Nazwisko';
   sg.Cells[ 2, ARow] := 'Imi';
   sg.Cells[ 3, ARow] := 'Ulica';
   sg.Cells[ 4, ARow] := 'Kod.p';
   sg.Cells[ 5, ARow] := 'Miejsc';
   sg.Cells[ 6, ARow] := 'Data ur';
   sg.Cells[ 7, ARow] := 'Pesel';
   sg.Cells[ 8, ARow] := 'Telefon';
   sg.Cells[ 9, ARow] := 'E-mail';
   sg.Cells[10, ARow] := 'Woj';
   sg.Cells[11, ARow] := 'Zarobek';
   Inc(ARow);

	sg.RowCount := ARow;
   // nie chc pustego ARowa na kocu
   // sg.RowCount := sg.RowCount + 1;

	Set_fixed();

   // wczenie opcji
	sg.Options := [goFixedVertLine,
                  goFixedHorzLine,
                  goVertLine,
                  goHorzLine,
                  goRangeSelect,
                  goRowSizing,
                  goColSizing,
                  goRowMoving,
                  goEditing,
                  goAlwaysShowEditor,
                  goColMoving];
end;

procedure TMainForm.Set_fixed();
begin
	if sg.RowCount > 1 then
   begin
	   sg.FixedCols := 1;
   	sg.FixedRows := 1;
   end;
end;

procedure TMainForm.Wypelnij_1();
var
	lp   : LongInt;
	ARow : LongInt;
   t1, t2, t3 : TTime;

begin
	sg.RowCount := 1;

   sg.Visible := false;
   lblINFO.Visible := true;

   t1 := Time();

   for lp := ROWS downto 1 do
   begin
      sg.RowCount := sg.RowCount + 1;
      ARow := sg.RowCount-1;

	   sg.Cells[ 0, ARow] := IntToStr(lp);
	   sg.Cells[ 1, ARow] := IntToStr(lp);
	   sg.Cells[ 2, ARow] := IntToStr(lp);
	   sg.Cells[ 3, ARow] := IntToStr(lp);
	   sg.Cells[ 4, ARow] := IntToStr(lp);
	   sg.Cells[ 5, ARow] := IntToStr(lp);
   	sg.Cells[ 6, ARow] := IntToStr(lp);
	   sg.Cells[ 7, ARow] := IntToStr(lp);
	   sg.Cells[ 8, ARow] := IntToStr(lp);
	   sg.Cells[ 9, ARow] := IntToStr(lp);
	   sg.Cells[10, ARow] := IntToStr(lp);
	   sg.Cells[11, ARow] := IntToStr(lp);
   end;

   t2 := Time();

   t3 := t2 - t1;

   sg.Visible := true;
	ShowMessage('Czas: ' + TimeToStr(t3));
end;

procedure TMainForm.Wypelnij_2();
var
	lp   : LongInt;
	ARow : LongInt;
   t1, t2, t3 : TTime;

begin
	// wyczys SG
	sg.RowCount := 1;

   sg.Visible := false;
   lblINFO.Visible := true;

   t1 := Time();

	sg.RowCount := ROWS + 1;

   for ARow := 1 to ROWS do
   begin
	   sg.Cells[ 0, ARow] := IntToStr(ARow);
	   sg.Cells[ 1, ARow] := IntToStr(ARow);
	   sg.Cells[ 2, ARow] := IntToStr(ARow);
	   sg.Cells[ 3, ARow] := IntToStr(ARow);
	   sg.Cells[ 4, ARow] := IntToStr(ARow);
	   sg.Cells[ 5, ARow] := IntToStr(ARow);
   	sg.Cells[ 6, ARow] := IntToStr(ARow);
	   sg.Cells[ 7, ARow] := IntToStr(ARow);
	   sg.Cells[ 8, ARow] := IntToStr(ARow);
	   sg.Cells[ 9, ARow] := IntToStr(ARow);
	   sg.Cells[10, ARow] := IntToStr(ARow);
	   sg.Cells[11, ARow] := IntToStr(ARow);
   end;

   t2 := Time();

   t3 := t2 - t1;

   sg.Visible := true;
	ShowMessage('Czas: ' + TimeToStr(t3));
end;

end.

